# Copyright (c) 2017-2025 Soft8Soft, LLC. All rights reserved.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

def register():
    import bpy, os

    repos = bpy.context.preferences.extensions.repos

    if 'Soft8Soft' in repos:
        repo = repos['Soft8Soft']

        if repo.use_custom_directory:
            print('V3D-ST-INFO: removing outdated Soft8Soft repository')
            repos.remove(repo)

def unregister():
    import os
    try:
        print('V3D-ST-INFO: removing repo migration script {}'.format(__file__))
        os.remove(__file__)
    except:
        print('V3D-ST-INFO: failed to remove repo migration script')
        print('V3D-ST-INFO: please remove {} manually'.format(__file__))
