
# edit this configuration to change how things are generated
PLATFORMS = {
    'android': {
        'cordova_icon': [
            {
                'filename': 'icon-{dpi_level}.png',
                'sizes': [
                    (36, 'ldpi'),
                    (48, 'mdpi'),
                    (72, 'hdpi'),
                    (96, 'xhdpi'),
                    (144, 'xxhdpi'),
                    (192, 'xxxhdpi'),
                ]
            }
        ],
        'favicon': [
            {
                'filename': 'android-chrome-{size}x{size}.png',
                'sizes': [192, 512],
            }
        ],
        'cordova_splash': [
            {
                'filename': 'screen-port-{dpi_level}.png',
                'sizes': [
                    (320, 426, 'ldpi'),
                    # (320, 470, 'mdpi'),
                    # (480, 640, 'hdpi'),
                    # (720, 960, 'xhdpi'),
                    (320, 480, 'mdpi'),
                    (480, 800, 'hdpi'),
                    (720, 1280, 'xhdpi'),
                ]
            },
            {
                'filename': 'screen-land-{dpi_level}.png',
                'sizes': [
                    (426, 320, 'ldpi'),
                    # (320, 470, 'mdpi'),
                    # (480, 640, 'hdpi'),
                    # (720, 960, 'xhdpi'),
                    (480, 320, 'mdpi'),
                    (800, 480, 'hdpi'),
                    (1280, 720, 'xhdpi'),
                ]
            }
        ]
    },
    'ios': {
        'cordova_icon': [
            {
                'filename': 'icon.png',
                'background': 'white',
                'sizes': [57]
            },
            {
                'filename': 'icon@2x.png',
                'background': 'white',
                'sizes': [114]
            },
            {
                'filename': 'icon-{size}.png',
                'background': 'white',
                'sizes': [40, 50, 60, 72, 76, 167, 1024]
            },
            {
                'filename': 'icon-small.png',
                'background': 'white',
                'sizes': [29]
            },
            {
                'filename': 'icon-small@2x.png',
                'background': 'white',
                'sizes': [58]
            },
            {
                'filename': 'icon-small@3x.png',
                'background': 'white',
                'sizes': [87]
            },
            {
                'filename': 'icon-{halfsize}@2x.png',
                'background': 'white',
                'sizes': [80, 100, 144, 120, 152]
            },
            {
                'filename': 'icon-{thirdsize}@3x.png',
                'background': 'white',
                'sizes': [180]
            },
        ],
        'favicon': [
            {
                'filename': 'apple-touch-icon.png',
                'sizes': [180],
            }
        ],
        'cordova_splash': [
            {
                'filename': 'Default-667h.png',
                'sizes': [ (445, 667) ]
            },
            {
                'filename': 'Default-736h.png',
                'sizes': [ (490, 736) ]
            },
            {
                'filename': 'Default-Landscape-736h.png',
                'sizes': [ (490, 736) ]
            },
            {
                'filename': 'Default-568h@2x~iphone.png',
                'sizes': [ (640, 1136) ]
            },
            {
                'filename': 'Default-Landscape@2x~ipad',
                'sizes': [ (2048, 1536) ]
            },
            {
                'filename': 'Default-Landscape~ipad',
                'sizes': [ (1024, 768) ]
            },
            {
                'filename': 'Default-Portrait@2x~ipad',
                'sizes': [ (1536, 2048) ]
            },
            {
                'filename': 'Default-Portrait~ipad',
                'sizes': [ (768, 1024) ]
            },
            {
                'filename': 'Default@2x~iphone.png',
                'sizes': [ (640, 960) ]
            },
            {
                'filename': 'Default~iphone.png',
                'sizes': [ (320, 480) ]
            }
        ]
    },
    'web': {
        'favicon': [
            {
                'filename': 'favicon-{size}x{size}.png',
                'sizes': [16, 32, 48],
            }
        ],
    },
}

